package examples.stateless.interceptors;

import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;

public class LoggerInterceptor {
	@AroundInvoke
	public Object logger(InvocationContext inv) throws Exception {
		System.out.println("Intercepted call via external class to: "+inv.getMethod().getName());
		Object[] params = inv.getParameters();
		for (int i=0;i<params.length;i++) {
			System.out.println("\tparam: "+params[i]);
		}
		return inv.proceed();
	}
}
